/*****************************************************************************
 * vlcglue.h: Main header for the Python binding
 *****************************************************************************
 * Copyright (C) 1998-2004 the VideoLAN team
 * $Id: 41623eb38eb1b59a379b3755763f43d93612e566 $
 *
 * Authors: Olivier Aubert <oaubert at bat710.univ-lyon1.fr>
 *          Clément Stenac <zorglub@videolan.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#include <Python.h>
#include "structmember.h"

#define __VLC__

#include <stdio.h>
#include <vlc/vlc.h>
#include <vlc/mediacontrol_structures.h>
#include <vlc/mediacontrol.h>

#define SELF ((MediaControl*)self)

/**********************************************************************
 * Exceptions handling
 **********************************************************************/

#define MC_TRY exception=mediacontrol_exception_init(exception)

#define MC_EXCEPT  \
  if( exception->code ) { \
    PyObject *py_exc = MediaControl_InternalException; \
    switch( exception->code ) { \
    case mediacontrol_InternalException: \
      py_exc = MediaControl_InternalException; \
      break; \
    case mediacontrol_PlaylistException: \
      py_exc = MediaControl_PlaylistException; \
      break; \
    case mediacontrol_InvalidPosition: \
      py_exc = MediaControl_InvalidPosition; \
      break; \
    case mediacontrol_PositionKeyNotSupported: \
      py_exc = MediaControl_PositionKeyNotSupported; \
      break; \
    case mediacontrol_PositionOriginNotSupported: \
      py_exc = MediaControl_PositionOriginNotSupported; \
      break; \
    } \
    PyErr_SetString( py_exc, exception->message ); \
    mediacontrol_exception_free( exception ); \
    return NULL; \
  } else { mediacontrol_exception_free( exception ); }

PyObject *MediaControl_InternalException;
PyObject *MediaControl_PositionKeyNotSupported;
PyObject *MediaControl_PositionOriginNotSupported;
PyObject *MediaControl_InvalidPosition;
PyObject *MediaControl_PlaylistException;

/**********************************************************************
 * VLC Object
 **********************************************************************/
#define VLCSELF ( ( vlcObject* )self )

/**********************************************************************
 * VLCObject Object
 **********************************************************************/
typedef struct
{
    PyObject_HEAD
    vlc_object_t* p_object;
    int b_released;
} vlcObject;

staticforward PyTypeObject vlcObject_Type;

/**********************************************************************
 * MediaControl Object
 **********************************************************************/
typedef struct
{
    PyObject_HEAD
    mediacontrol_Instance* mc;
}MediaControl;

staticforward PyTypeObject MediaControl_Type;

/**********************************************************************
 * Position Object
 **********************************************************************/
typedef struct
{
    PyObject_HEAD
    int origin;
    int key;
    PY_LONG_LONG value;
} PyPosition;

staticforward PyTypeObject PyPosition_Type;

mediacontrol_PositionKey positionKey_py_to_c( PyObject * py_key );
mediacontrol_PositionOrigin positionOrigin_py_to_c( PyObject * py_origin );
mediacontrol_Position * position_py_to_c( PyObject * py_position );
PyPosition * position_c_to_py( mediacontrol_Position * position );

/* Long long conversion on Mac os X/ppc */
#if defined (__ppc__) || defined(__ppc64__)
#define ntohll(x) ((long long) x >> 64)
#else
#define ntohll(x) (x)
#endif

