/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.user;

import java.util.Iterator;
import java.util.Vector;

public class Preference {
    private String name;
    private Vector values = new Vector();

    protected Preference() {
    }

    public Preference(String name, String value) {
        this.name = name;
        if (value != null) {
            this.values.add(value);
        }
    }

    public Preference(String name, String[] value) {
        this.name = name;
        for (int i = 0; i < value.length; ++i) {
            this.values.add(value[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String value) {
        Vector vector = this.values;
        synchronized (vector) {
            this.values.remove(value);
            this.values.add(value);
        }
    }

    public void add(String[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.add(value[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int position, String value) {
        Vector vector = this.values;
        synchronized (vector) {
            this.values.remove(value);
            if (position < 0) {
                position = 0;
            } else if (position > this.values.size()) {
                position = this.values.size();
            }
            this.values.add(position, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFavourites() {
        Vector vector = this.values;
        synchronized (vector) {
            if (this.values.isEmpty()) {
                return new String[0];
            }
            Object[] result = new String[this.values.size()];
            this.values.copyInto(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMostFavourite() {
        Vector vector = this.values;
        synchronized (vector) {
            if (this.values.isEmpty()) {
                return null;
            }
            return (String)this.values.get(0);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPosition(String value) {
        Vector vector = this.values;
        synchronized (vector) {
            return this.values.indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValue() {
        Vector vector = this.values;
        synchronized (vector) {
            return !this.values.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String value) {
        Vector vector = this.values;
        synchronized (vector) {
            this.values.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Vector vector = this.values;
        synchronized (vector) {
            this.values.clear();
        }
    }

    public void setMostFavourite(String value) {
        this.add(0, value);
    }

    public String toString() {
        String result = "Preference:" + this.name + "[";
        String comma = "";
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            result = result + comma + (String)it.next();
            comma = ",";
        }
        result = result + ']';
        return result;
    }
}

