/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XCheckIfEvent(display, event_return, predicate, arg)
 *   Display *display;
 *   XEvent	*event_return;
 *   Predicate predicate;
 *   char *arg;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCheckIfEvent	1
char    *TestName = "XCheckIfEvent";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XCheckIfEvent function
 */
static Display *display;
static XEvent	*event_return;
static Predicate predicate;
static char *arg;


/*
 * Can not use "xcall" because it empties the event queue.
 */
#define	_xcall_(rvalue)	\
		_startcall(display);\
		rvalue = XCheckIfEvent(display, event_return, predicate, arg);\
		_endcall(display)
static XEvent _event;

/*
 * _predicate - a predicate procedure
 *
 * _predicate returns True only after it has been invoked the specified
 * number of times (_pred_max).  _pred_cnt is used to keep track of the
 * number of invocations.  _pred_retval always contains the previous
 * _predicate return value.  _pred_true is set to True if _predicate is
 * ever invoked while _pred_retval is set to True.  _pred_event contains
 * a copy of the event most recently passed to _predicate.
 *
 * These variables should be initialized by a call to PRED_SETUP() prior
 * to (indirectly!) invoking the predicate procedure.  PRED_SETUP takes
 * an argument which specifies at which invocation _predicate should
 * start returning True.
 */
static int _pred_max;
static int _pred_cnt;		/* _predicate invocation counter */
static XEvent _pred_event;	/* last event passed to _predicate */
static int _pred_retval;	/* last returnvalue from _predicate */
static int _pred_true;		/* True when True previously returned */

static Bool
_predicate (display, event, arg)
Display *display;
XEvent *event;
char *arg;
{
#ifdef	lint
	XCloseDisplay(display);
	*arg = '\0';
#endif
	_pred_event = *event;
	if (_pred_retval == True)
		_pred_true = True;
	_pred_retval = ((++_pred_cnt >= _pred_max) ? True : False);
	return(_pred_retval);
}

#define	PRED_SETUP(max)	\
		_pred_max = (max);\
		_pred_cnt = 0;\
		_pred_retval = False;\
		_pred_true = False


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	event_return = &_event;
	predicate = _predicate;
	arg = (char *) 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XEvent	event;
int	callcnt;
int	returnvalue;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCheckIfEvent-1.(A)");
	report_assertion("A call to XCheckIfEvent calls predicate once for each event");
	report_assertion("in the event queue until predicate returns True.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Set up predicate procedure.");
	report_strategy("Call XCheckIfEvent.");
	report_strategy("Verify that predicate was called the correct number of times.");
	report_strategy("Verify that predicate returned True at most recent invocation.");
	report_strategy("Verify that XCheckIfEvent did not continue to call predicate");
	report_strategy("after predicate returned True.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 2);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Verify that predicate was called the correct number of times. */
	if (_pred_cnt != callcnt) {
		report("predicate called %d times, expected %d", _pred_cnt, callcnt);
		FAIL;
	}
	else
		CHECK;
/* Verify that predicate returned True at most recent invocation. */
	if (_pred_retval != True) {
		report("predicate returned %d, expecting %d", _pred_retval, True);
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent did not continue to call predicate */
/* after predicate returned True. */
	if (_pred_true == True) {	
		report("Did not return when predicate returned True.");
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);
	
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XEvent	event;
int	callcnt;
int	returnvalue;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCheckIfEvent-2.(A)");
	report_assertion("When a call to XCheckIfEvent finds a matching event, then");
	report_assertion("XCheckIfEvent True.");

	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Set up predicate procedure.");
	report_strategy("Call XCheckIfEvent.");
	report_strategy("Verify that predicate found a matching event.");
	report_strategy("Verify that XCheckIfEvent returned True.");

	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 2);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Verify that predicate found a matching event. */
	if (_pred_cnt != callcnt) {
		report("predicate called %d times, expected %d", _pred_cnt, callcnt);
		FAIL;
	}
	else
		CHECK;
	if (_pred_retval != True) {
		report("predicate returned %d, expecting %d", _pred_retval, True);
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent returned True. */
	if (returnvalue != True) {
		report("Returned %d, expecting %d", returnvalue, True);
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);
	
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XEvent	event;
XEvent	nextevent;
int	returnvalue;
int	callcnt;
int	oldqsize;
int	newqsize;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCheckIfEvent-3.(A)");
	report_assertion("A call to XCheckIfEvent removes the returned event from the");
	report_assertion("event queue.");


	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Call XPending to get the current event queue size. */
	oldqsize = XPending(display);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 1);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Verify that XCheckIfEvent returned True. */
	if (returnvalue != True) {	
		report("Returned %d, expecting %d", _pred_retval, True);
		FAIL;
	}
	else
		CHECK;
/* Call XPending to get the current event queue size. */
	newqsize = XPending(display);
/* Verify that size of the event queue has decreased by one. */
	if (newqsize != (oldqsize-1)) {
		report("Event queue size %d, expected %d", newqsize, oldqsize-1);
		FAIL;
	}
	else
		CHECK;
/* Verify that the returned event was removed from the event queue. */
	XNextEvent(display, &nextevent);
	if (event_return->type == nextevent.type) {
		report("Returned %s, expected %s", eventname(event_return->type), eventname(ButtonPress));
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XEvent	event;
int	callcnt;
int	returnvalue;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCheckIfEvent-4.(A)");
	report_assertion("When on a call to XCheckIfEvent predicate returns True,");
	report_assertion("then XCheckIfEvent returns the event passed to predicate in");
	report_assertion("event_return.");


	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 2);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Verify that predicate returned True at most recent invocation. */
	if (_pred_retval != True) {
		report("predicate returned %d, expecting %d", _pred_retval, True);
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent returned True. */
	if (returnvalue != True) {	
		report("Returned %d, expecting %d", _pred_retval, True);
		FAIL;
	}
	else
		CHECK;
/* Verify that event_return is the same as the event passed to predicate. */
	if (event_return->type != _pred_event.type) {	
		report("Returned %s, expected %s", eventname(event_return->type), eventname(_pred_event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that event_return is the expected event. */
	if (event_return->type != KeyRelease) {	
		report("Returned %s, expected %s", eventname(event_return->type), eventname(KeyRelease));
		FAIL;
	}
	else
		CHECK;
/* Verify that XIfEvent did not continue to call predicate */
/* after predicate returned True. */
	if (_pred_true == True) {	
		report("Did not return when predicate returned True.");
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XEvent	event;
int	callcnt;
int	returnvalue;
int	qsize;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCheckIfEvent-5.(A)");
	report_assertion("When on a call to XCheckIfEvent predicate has not returned");
	report_assertion("True after having been called once for each event in the");
	report_assertion("event queue, then XCheckIfEvent returns False.");


	tpstartup();
	setargs();
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Call XPending to get the current event queue size. */
	qsize = XPending(display);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 100);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Verify that predicate never returned True. */
	if (_pred_retval == True) {
		report("Predicate erroneously returned True.");
		FAIL;
	}
	else
		CHECK;
	if (_pred_true == True) {
		report("Predicate erroneously returned True.");
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent returned False. */
	if (returnvalue != False) {
		report("returned %d, expecting %d", returnvalue, False);
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent called predicate once for */
/* each event in the event queue. */
	if (_pred_cnt != qsize) {	
		report("predicate called %d times, expected %d", _pred_cnt, qsize);
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);
	
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XEvent	event;
int	callcnt;
int	returnvalue;
int	qsize;
Pixmap	pm;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCheckIfEvent-6.(A)");
	report_assertion("When on a call to XCheckIfEvent predicate has not returned");
	report_assertion("True after having been called once for each event in the");
	report_assertion("event queue, then XCheckIfEvent flushes the output buffer.");

	report_strategy("Create client2.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XPending to get the current event queue size.");
	report_strategy("Set up predicate procedure.");
	report_strategy("Call XCheckIfEvent.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was flushed by effect on server.");
	report_strategy("Verify that predicate never returned True.");
	report_strategy("Verify that XCheckIfEvent returned False.");
	report_strategy("Verify that XCheckIfEvent called predicate once for");
	report_strategy("each event in the event queue.");

	tpstartup();
	setargs();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Call XPutBackEvent to put events on the event queue. */
	event.type = KeyPress;
	XPutBackEvent(display, &event);
	event.type = KeyRelease;
	XPutBackEvent(display, &event);
	event.type = ButtonPress;
	XPutBackEvent(display, &event);
/* Call XPending to get the current event queue size. */
	qsize = XPending(display);
/* Set up predicate procedure. */
	PRED_SETUP(callcnt = 100);
/* Call XCheckIfEvent. */
	_xcall_(returnvalue);
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() != Success) {
		report("The output buffer was not flushed.");
		XFreePixmap(display, pm);
		FAIL;
	}
	else
		CHECK;
/* Verify that predicate never returned True. */
	if (_pred_retval == True) {
		report("Predicate erroneously returned True.");
		FAIL;
	}
	else
		CHECK;
	if (_pred_true == True) {
		report("Predicate erroneously returned True.");
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent returned False. */
	if (returnvalue != False) {
		report("returned %d, expecting %d", returnvalue, False);
		FAIL;
	}
	else
		CHECK;
/* Verify that XCheckIfEvent called predicate once for */
/* each event in the event queue. */
	if (_pred_cnt != qsize) {	
		report("predicate called %d times, expected %d", _pred_cnt, qsize);
		FAIL;
	}
	else
		CHECK;
	/* empty event queue */
	XSync(display, True);
	
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
