/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XGetPointerMapping(display, map_return, nmap)
 *   Display	*display;
 *   unsigned char	*map_return;
 *   int 	nmap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetPointerMapping	1
char    *TestName = "XGetPointerMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetPointerMapping function
 */
static Display	*display;
static unsigned char	*map_return;
static int 	nmap;


static int 	ValueReturn;


#define	MAPSIZE	32
static	unsigned char	Map[MAPSIZE];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	map_return = Map;
	nmap = MAPSIZE;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	nbuttons;
int	i;
Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetPointerMapping-1.(B)");
	report_assertion("A call to XGetPointerMapping returns in map_return[i] the");
	report_assertion("logical button numbers of the physical buttons i+1.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetPointerMapping to get pointer mapping.");
	report_strategy("If extension available:");
	report_strategy("  Create window and map it.");
	report_strategy("  Select for ButtonPress events.");
	report_strategy("  Warp into window.");
	report_strategy("  For i in 1..nphysbuttons");
	report_strategy("    Simulate pressing button i.");
	report_strategy("    Check for incoming ButtonPress event.");
	report_strategy("    Check that event.xbutton.button is map_return[i-1].");
	report_strategy("    Release all buttons.");
	report_strategy("else");
	report_strategy("  UNTESTED touch test only.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetPointerMapping(display, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	trace("Number of buttons reported as %d", nbuttons);

	if (noext(nbuttons)) {
		report("There is no reliable test method, but a touch test was performed");
		UNTESTED;
		return;
	} else
		CHECK;
	win = defwin(display);
	if (isdeleted()) {
		delete("Failed to create ButtonPress window.");
		return;
	} else
		CHECK;
	XSelectInput(display, win, ButtonPressMask);
	XSync(display, True);
	if (isdeleted()) {
		delete("Failed to select for ButtonPress. May indicate competing clients (e.g. window managers).");
		return;
	} else
		CHECK;
	warppointer(display, win, 2, 2);
	for (i=0; i<nbuttons; i++) {
		XEvent ev;

		XSync(display, True); /* clear out event Q */
		_startcall(display); /* install and reset error handlers */
		buttonpress(display, (unsigned int)i+1);
		if (!XCheckWindowEvent(display, win, ButtonPressMask, &ev)) {
			delete("No event received for button %d.", i+1);
			relalldev();
			return;
		} else
			CHECK;
		relalldev();
		_endcall(display); /* back to catching unexpected ones */
		if (ev.xbutton.button != map_return[i]) {
			report("Mapping for button %d is %d not %d.",
				i+1, (int)ev.xbutton.button, (int)map_return[i]);
			FAIL;
		} else
			CHECK;
		trace("Mapping for button %d is %d, expecting %d.",
				i+1, (int)ev.xbutton.button, (int)map_return[i]);
	}
	CHECKPASS(3+2*nbuttons);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	nbuttons;
int	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetPointerMapping-2.(B)");
	report_assertion("A call to XGetPointerMapping returns the number of physical");
	report_assertion("buttons actually on the pointer.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetPointerMapping to get number of buttons.");
	report_strategy("Check this lies within the limit.");
	report_strategy("If extension available:");
	report_strategy("  Simulate the pressing of buttons 1..n and check that");
	report_strategy("    we got Success for buttons in the range returned by XGetPointerMapping, and");
	report_strategy("    we got BadValue for the rest.");
	report_strategy("  Release all buttons.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetPointerMapping(display, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (nbuttons < 1 || nbuttons > MAPSIZE) {
		report("Limit of 1..%d buttons exceeded (%d).", MAPSIZE, nbuttons);
		FAIL;
	} else
		CHECK;

	if (noext(nbuttons)) {
		report("There is no reliable test method, but a touch test was performed");
		UNTESTED;
		return;
	} else
		CHECK;

	for(i=0; i<MAPSIZE; i++) {
		_startcall(display); /* install and reset error handlers */
		buttonpress(display, (unsigned int)i+1);
		if (geterr() != ((i<nbuttons)?Success:BadValue)) {
			report("Apparently button %d could%s be pressed.",
				i+1, (i<nbuttons)?"n't":"");
			FAIL;
		} else
			CHECK;
		relalldev();
		_endcall(display); /* back to catching unexpected ones */
	}
	CHECKPASS(2+MAPSIZE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	nbuttons;
int 	i;
#define	TEST_VAL	((unsigned char)255)
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetPointerMapping-3.(A)");
	report_assertion("When the nmap argument is less than the number of elements");
	report_assertion("in the pointer mapping, then only the first nmap elements");
	report_assertion("are returned in map_return.");

	report_strategy("Set all elements of map_return to 255.");
	report_strategy("Set nmap to a value less than number of elements in the pointer mapping.");
	report_strategy("Call XGetPointerMapping.");
	report_strategy("Verify that elements of map_return beyond nmap-1 are still 255.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetPointerMapping(display, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 0; i < MAPSIZE; i++)
		Map[i] = TEST_VAL;

	/*
	 * Its not clear that asking for 0 elements is really sensible so we
	 * only do it when there is only one button.
	 */
	if (nbuttons == 1)
		nmap = 0;
	else
		nmap = 1;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGetPointerMapping(display, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = nmap; i < MAPSIZE; i++) {
		if (Map[i] != TEST_VAL) {
			report("An element beyond the first nmap was returned");
			report(" element %d was %u, expecting %u", i, (unsigned)Map[i],
				(unsigned)TEST_VAL);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(MAPSIZE-nmap);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
