/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Region
 *   XPolygonRegion(points, n, fill_rule)
 *   XPoint	*points;
 *   int	n;
 *   int	fill_rule;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XPolygonRegion	1
char    *TestName = "XPolygonRegion";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XPolygonRegion function
 */
static XPoint	*points;
static int	n;
static int	fill_rule;


XPoint	poly1[] = { {20,20}, {35,10}, {55,10}, {80,20}, {90,35}, {85,50}, {75,65}, {50,70}, {30,65}, {20,60}, {15,40} };
XPoint	poly2[] = { {75,60}, {60,45}, {55,60}, {30,55}, {35,35}, {15,40}, {20,18}, {45,10}, {70,15}, {55,30}, {80,45} };
XPoint	poly3[] = { {85,40}, {30,20}, {20,55}, {30,69}, {55,35}, {85,44}, {10,43}, {14,66} };
/*
 * The same polygon used in XFillPolygon tests.
 */
XPoint   compshape[] = { {10, 10},  {80, 10},  {100, 30},  {65, 60},  {65, 30}, {85, 60},
                         {30, 50},  {30, 80},  {60, 80},   {60, 5},   {70, 5},  {70, 100}, {10, 100},
};

struct prec {
	XPoint	*points;
	int	size;
} poly[] = { 	{poly1, NELEM(poly1)},
		{poly2, NELEM(poly2)},
		{compshape, NELEM(compshape)}	};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	points = 0;
	n = 99;
	fill_rule = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int     loop;
XVisualInfo	*vi;
Region	reg;
Window	win;
GC	gc;
unsigned int    width;
unsigned int    height;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XPolygonRegion-1.(A)");
	report_assertion("A call to XPolygonRegion returns a region comprising the");
	report_assertion("interior of the filled polygon as described by the n points");
	report_assertion("specified by the points argument, filled with the fill_rule");
	report_assertion("argument.");

	report_strategy("For a convex, concave and complex polygon :");
	report_strategy("   For fill_rule = EvenOddRule, WindingRule :");
	report_strategy("      Create a polygon region using XPolygonRegion.");
	report_strategy("      Create a gc using XCreateGC.");
	report_strategy("      Set the foreground of the GC to W_FG ^ W_BG.");
	report_strategy("      Create a drawable with background W_BG using XCreateWindow.");
	report_strategy("      Fill the polygon on the drawable using XFillPolygon.");
	report_strategy("      Set the GC clipmask to the region using XSetRegion.");
	report_strategy("      Set the graphics function of the GC to GXxor using XSetFunction.");
	report_strategy("      Fill the drawable using XFillRectangle.");
	report_strategy("      Verify that the entire drawable is W_BG.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vi);

	for(loop=0; loop < NELEM(poly); loop++) {
	
		win = makewin(Dsp, vi);
		gc = makegc(Dsp, win);
		fill_rule = EvenOddRule;
		XSetFillRule(Dsp, gc, fill_rule);
		XSetFillStyle(Dsp, gc, FillSolid);
		XSetFunction(Dsp, gc, GXxor);
		XSetForeground(Dsp, gc, W_BG^W_FG);
		points = poly[loop].points;
		n = poly[loop].size;
		startcall(Dsp);
		if (isdeleted())
			return;
		reg = XPolygonRegion(points, n, fill_rule);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		getsize(Dsp, win, &width, &height);
		XFillPolygon(Dsp, win, gc, points, n, Complex, CoordModeOrigin);
		if( checkarea(Dsp, win, (struct area *) NULL, W_BG, W_BG, CHECK_ALL|CHECK_DIFFER)){
			delete("XFillPolygon() did set any pixels to non-background values.");
			return;
		} else
			CHECK;
		XSetRegion(Dsp, gc, reg);
		XFillRectangle(Dsp, win, gc, 0,0, width, height);	

		if( checkarea(Dsp, win, (struct area *) NULL, W_BG, W_BG, CHECK_ALL) == 0){
			report("When used as a clip-mask in a GC,");
			report("the polygon region did not produce the expected clipping.");
			report("Results depend on the correctness of XFillPolygon().");
			FAIL;
		} else
			CHECK;
		XDestroyRegion(reg);

		win = makewin(Dsp, vi);
		gc = makegc(Dsp, win);
		fill_rule = WindingRule;
		XSetFillRule(Dsp, gc, fill_rule);
		XSetFillStyle(Dsp, gc, FillSolid);
		XSetFunction(Dsp, gc, GXxor);
		XSetForeground(Dsp, gc, W_BG^W_FG);
		startcall(Dsp);
		if (isdeleted())
			return;
		reg = XPolygonRegion(points, n, fill_rule);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		getsize(Dsp, win, &width, &height);
		XFillPolygon(Dsp, win, gc, points, n, Complex, CoordModeOrigin);
		if( checkarea(Dsp, win, (struct area *) NULL, W_BG, W_BG, CHECK_ALL|CHECK_DIFFER)){
			delete("XFillPolygon() did set any pixels to non-background values.");
			return;
		} else
			CHECK;
		XSetRegion(Dsp, gc, reg);
		XFillRectangle(Dsp, win, gc, 0,0, width, height);	

		if( checkarea(Dsp, win, (struct area *) NULL, W_BG, W_BG, CHECK_ALL) == 0){
			report("When used as a clip-mask in a GC,");
			report("the polygon region did not produce the expected clipping.");
			report("Results depend on the correctness of XFillPolygon().");
			FAIL;
		} else
			CHECK;
		XDestroyRegion(reg);
	}

	CHECKPASS(NELEM(poly) * 4);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
