/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppMainLoop()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
extern char *event_names[];
Widget labelw_msg;

XtInputId input_ret;
char *msg = "Hello World";
FILE *fid;
/* Procedure XtIOP_Proc */
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(1,1);
	exit(0);
}

void XtEVT_Proc2(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XKeyEvent *tevent;

	tevent = (XKeyEvent *)event;

	tet_infoline("TEST: Event timestamp returned by XtLastTimestampProcessed");
	if (tevent->time != XtLastTimestampProcessed(XtDisplay(w))) {
		sprintf(ebuf, "ERROR: event->time = %ld, XtLastTimestampProcessed returned %ld", (unsigned long)tevent->time, (unsigned long)XtLastTimestampProcessed(XtDisplay(w)));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress )
		avs_set_event(1, 1); 
	if (event->type == ButtonRelease )
		avs_set_event(2, 1); 
	if (event->type == KeyPress )
		avs_set_event(3, 1); 
	if (event->type == KeyRelease )
		avs_set_event(4, 1); 
}
/*
** XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if ((Widget)client_data != topLevel) {
		tet_infoline("ERROR: client_data not passed correctly to event handler");
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress)
		avs_set_event(1,avs_get_event(1)+1);
	else {
		sprintf(ebuf, "ERROR: Expected ButtonPress event Received %s", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
/*
** XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}
void XtTMO_Proc5(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send events");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, 1);
	send_event_time(labelw_msg, ButtonRelease, ButtonReleaseMask, TRUE, 2);
	send_event_time(labelw_msg, KeyRelease, KeyReleaseMask, TRUE, 3);
	send_event_time(labelw_msg, KeyPress, KeyPressMask, TRUE, 4);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
}
void XtTMO_Proc1(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(1,1);
	exit(0);
}
void XtTMO_Proc2(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Send events after having delayed a bit");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
}


#define T_XtAppMainLoop	1
char    *TestName = "XtAppMainLoop";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *msg = "Event widget";
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppMainLoop-1.(A)");
	report_assertion("A successful call to void XtAppMainLoop(app_context) shall");
	report_assertion("perform an infinite loop that reads an incoming X event for");
	report_assertion("the application context app_context and calls the registered");
	report_assertion("event handler procedure for the widget to which the event is");
	report_assertion("dispatched and not return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapmnloop1", "XtAppMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Send ButtonPress events over wire to labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	send_event(labelw_msg, ButtonPress, ButtonPressMask, TRUE);
	tet_infoline("TEST: Add time out procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Loop for events until timeout");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Event handler was invoked for all events");
	status = avs_get_event(1);
	check_dec(3, status, "Event Handler invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11381 */
/* End of included file Mdefcode.tmc.11381 */

static void t002(){

char *msg = "Event widget";
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppMainLoop-2.(A)");
	report_assertion("When there are no events in the X input queue of the");
	report_assertion("specified application context a call to void");
	report_assertion("XtAppMainLoop(app_context) shall flush the X output buffers");
	report_assertion("of each display in the application context and wait until an");
	report_assertion("event from the X server is available.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapmnloop1", "XtAppMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Add time out procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc2, topLevel);
	tet_infoline("TEST: Loop for events");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Event handler was invoked for all events");
	status = avs_get_event(1);
	check_dec(3, status, "Event Handler invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11381 */
/* End of included file Mdefcode.tmc.11381 */

static void t003(){

char *msg = "Event widget";
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppMainLoop-3.(A)");
	report_assertion("When a timeout occurs in the application context");
	report_assertion("app_context on a call to void XtAppMainLoop(app_context)");
	report_assertion("while it is blocked to read an event from the queue the");
	report_assertion("designated timeout callback procedure shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapmnloop1", "XtAppMainLoop");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Add time out procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc1, topLevel);
	tet_infoline("TEST: Loop for events");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: time out procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "time out procedure invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11381 */
/* End of included file Mdefcode.tmc.11381 */

static void t004(){

char *data;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppMainLoop-4.(A)");
	report_assertion("When an input from an alternate input source occurs in the");
	report_assertion("application context app_context on a call to void");
	report_assertion("XtAppMainLoop(app_context) while it is blocked to read an");
	report_assertion("event from the queue the designated input source callback");
	report_assertion("procedure shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = "tapmnloop.dat";
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	FORK(pid2);
	avs_xt_hier("Tapmnloop", "XtAppMainLoop");
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Input procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	unlink(data);
	status = avs_get_event(1);
	check_dec(1, status, "XtIOP_Proc invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11381 */
/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppMainLoop-5.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtAppMainLoop(app_context) when an event obtained from the");
	report_assertion("input queue caused a server keyboard grab for a widget in");
	report_assertion("the application context app_context and an input method has");
	report_assertion("been registered on this event for the widget it shall cancel");
	report_assertion("the grab and not call the event handler procedure registered");
	report_assertion("for the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppMainLoop-6.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtAppMainLoop(app_context) when an event obtained from the");
	report_assertion("input queue caused a server pointer grab for a widget in the");
	report_assertion("application context app_context and an input method has been");
	report_assertion("registered on this event for the widget it shall cancel the");
	report_assertion("grab and not call the event handler procedure registered for");
	report_assertion("the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

static void t007(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
int pstatus;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAppMainLoop-7.(A)");
	report_assertion("On a call to void XtAppMainLoop(app_context) when an event");
	report_assertion("read from the incoming event queue for the specified");
	report_assertion("application context is a KeyPress, KeyRelease, ButtonPress,");
	report_assertion("ButtonRelease, MotionNotify, EnterNotify, LeaveNotify,");
	report_assertion("PropertyNotify or SelectionClear event it shall record the");
	report_assertion("timestamp from the event as the last timestamp value that");
	report_assertion("will be returned by the next call to");
	report_assertion("XtLastTimestampProcessed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapmnloop1", "XtAppMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc2 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask,
		 False,
		 XtEVT_Proc2,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure which will cause event");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc5, topLevel);
	tet_infoline("TEST: Call XtAppMainLoop");
	XtAppMainLoop(app_ctext);
	tet_infoline("ERROR: XtAppMainLoop returned");
	tet_result(TET_FAIL);
	KROF(pid2);
	tet_infoline("TEST: Events were received");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "Handler invocation for ButtonPress count");
	invoked = avs_get_event(2);
	check_dec(1, invoked, "Handler invocation for ButtonRelease count");
	invoked = avs_get_event(3);
	check_dec(1, invoked, "Handler invocation for KeyPress count");
	invoked = avs_get_event(4);
	check_dec(1, invoked, "Handler invocation for KeyRelease count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11381 */
/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtAppMainLoop-8.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtAppMainLoop(app_context) when an event read from the");
	report_assertion("incoming event queue for the specified application context");
	report_assertion("is a remap event, a modal cascade exists that has a widget");
	report_assertion("with spring_loaded field set to True, and no event input");
	report_assertion("filter has been registered for the spring-loaded widget");
	report_assertion("window on the specified event it shall dispatch the event to");
	report_assertion("the spring-loaded widget following a dispatch to the widget");
	report_assertion("to which the event belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtAppMainLoop-9.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtAppMainLoop(app_context) when an event read from the");
	report_assertion("incoming event queue is a remap event, a modal cascade");
	report_assertion("exists that has a widget with spring_loaded field set to");
	report_assertion("True, and an event input filter has been registered for the");
	report_assertion("spring-loaded widget window on the specified event it shall");
	report_assertion("not dispatch the event to the spring-loaded widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtAppMainLoop-10.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the widget class field compress_motion set");
	report_assertion("to True a call to void XtAppMainLoop(app_context) shall");
	report_assertion("dispatch only the last motion event when there are");
	report_assertion("successive motion events pending for the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtAppMainLoop-11.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the widget class field compress_enterleave");
	report_assertion("set to True a call to void XtAppMainLoop(app_context) shall");
	report_assertion("not dispatch pairs of enter and leave events that have no");
	report_assertion("intervening events to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtAppMainLoop-12.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeNoCompress flag set in its");
	report_assertion("widget class field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause every exposure event");
	report_assertion("for the specified widget to be dispatched individually to");
	report_assertion("its expose procedure with the region argument set to NULL.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtAppMainLoop-13.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressSeries flag set in its");
	report_assertion("widget class field compress_exposure, a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause each series of");
	report_assertion("exposure events for the specified widget to be coalesced");
	report_assertion("into a single event and dispatched to its expose procedure");
	report_assertion("when an exposure event with count equal to zero occurs.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtAppMainLoop-14.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMultiple flag set in its");
	report_assertion("widget class field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause consecutive series of");
	report_assertion("exposure events for the specified widget to be coalesced");
	report_assertion("into a single event and dispatched to its expose procedure");
	report_assertion("when an exposure event whose count equal to zero is");
	report_assertion("encountered and either the event queue is empty or the next");
	report_assertion("event is not an exposure event for the specified widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtAppMainLoop-15.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMaximal flag set in its");
	report_assertion("widget class field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause all series of");
	report_assertion("exposure events in the queue for the specified widget to be");
	report_assertion("coalesced into a single event without regard to intervening");
	report_assertion("non-exposure events and dispatched to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t016(){

pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtAppMainLoop-16.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeNoCompress and the");
	report_assertion("XtExposeGraphicsExpose flags set in its widget class field");
	report_assertion("compress_exposure a call to void XtAppMainLoop(app_context)");
	report_assertion("shall cause all GraphicsExpose events for the specified");
	report_assertion("widget to be dispatched individually to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtAppMainLoop-17.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressSeries and the");
	report_assertion("XtExposeGraphicsExpose flags set in its widget class field");
	report_assertion("compress_exposure a call to void XtAppMainLoop(app_context)");
	report_assertion("shall cause each series of GraphicsExpose events for the");
	report_assertion("specified widget to be coalesced into a single event and");
	report_assertion("dispatched to its expose procedure when a GraphicsExpose");
	report_assertion("event whose count is equal to zero is encountered.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtAppMainLoop-18.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMultiple and the");
	report_assertion("XtExposeGraphicsExpose flags set in its widget class field");
	report_assertion("compress_exposure a call to void XtAppMainLoop(app_context)");
	report_assertion("shall cause consecutive series of GraphicsExpose events for");
	report_assertion("the specified widget to be coalesced into a single event and");
	report_assertion("dispatched to its expose procedure when a GraphicsExpose");
	report_assertion("event whose count is equal to zero is encountered and either");
	report_assertion("the event queue is empty or the next event is not an");
	report_assertion("GraphicsExpose event for the specified widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t019(){

pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtAppMainLoop-19.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMaximal and the");
	report_assertion("XtExposeGraphicsExpose flags set in its widget class field");
	report_assertion("compress_exposure a call to void XtAppMainLoop(app_context)");
	report_assertion("shall cause all series of GraphicsExpose events in the queue");
	report_assertion("for the specified widget to be coalesced into a single event");
	report_assertion("without regard to intervening non-GraphicsExpose events and");
	report_assertion("dispatched to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t020(){

pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtAppMainLoop-20.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeNoCompress and the");
	report_assertion("XtExposeGraphicsExposeMerged flags set in its widget class");
	report_assertion("field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause all exposure and");
	report_assertion("GraphicsExpose events for the specified widget to be");
	report_assertion("dispatched individually to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t021(){

pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtAppMainLoop-21.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressSeries and the");
	report_assertion("XtExposeGraphicsExposeMerged flags set in its widget class");
	report_assertion("field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause each series of");
	report_assertion("exposure and GraphicsExpose events for the widget to be");
	report_assertion("coalesced into a single event and dispatched to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t022(){

pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtAppMainLoop-22.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMultiple and the");
	report_assertion("XtExposeGraphicsExposeMerged flags set in its widget class");
	report_assertion("field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause consecutive series of");
	report_assertion("exposure and GraphicsExpose events for the specified widget");
	report_assertion("to be coalesced into a single event and dispatched to its");
	report_assertion("expose procedure when an exposure and a GraphicsExpose event");
	report_assertion("with count equal to zero are encountered and either the");
	report_assertion("event queue is empty or the next event is neither an");
	report_assertion("exposure nor a GraphicsExpose event for the specified");
	report_assertion("widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t023(){

pid_t	pid;

 	report_purpose(23);

	report_assertion("Assertion XtAppMainLoop-23.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeCompressMaximal and the");
	report_assertion("XtExposeGraphicsExposeMerged flags set in its widget class");
	report_assertion("field compress_exposure a call to void");
	report_assertion("XtAppMainLoop(app_context) shall cause all series of");
	report_assertion("exposure and GraphicsExpose events in the queue for the");
	report_assertion("specified widget to be coalesced into a single event without");
	report_assertion("regard to intervening non-exposure and non-GraphicsExpose");
	report_assertion("events and dispatched to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t024(){

pid_t	pid;

 	report_purpose(24);

	report_assertion("Assertion XtAppMainLoop-24.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the XtExposeNoExpose flag set with any one");
	report_assertion("of XtExposeNoCompress, XtExposeCompressSeries,");
	report_assertion("XtExposeCompressMultiple or XtExposeCompressMaximal flags");
	report_assertion("set in its widget class field compress_exposure a call to");
	report_assertion("void XtAppMainLoop(app_context) shall cause all NoExpose");
	report_assertion("events for the specified widget to be dispatched");
	report_assertion("individually to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t025(){

pid_t	pid;

 	report_purpose(25);

	report_assertion("Assertion XtAppMainLoop-25.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the visible_interest field in its class");
	report_assertion("record set to True a call to void XtAppMainLoop(app_context)");
	report_assertion("shall dispatch VisibilityUnobscured events to the widget and");
	report_assertion("set the visible field in the core widget structure to True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t026(){

pid_t	pid;

 	report_purpose(26);

	report_assertion("Assertion XtAppMainLoop-26.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the visible_interest field in its class");
	report_assertion("record set to True a call to void XtAppMainLoop(app_context)");
	report_assertion("shall dispatch VisibilityPartiallyObscured events to the");
	report_assertion("widget and set the visible field in the core widget");
	report_assertion("structure to True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t027(){

pid_t	pid;

 	report_purpose(27);

	report_assertion("Assertion XtAppMainLoop-27.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the visible_interest field in its class");
	report_assertion("record set to True a call to void XtAppMainLoop(app_context)");
	report_assertion("shall dispatch VisibilityFullyObscured events to the widget");
	report_assertion("and set the visible field in the core widget structure to");
	report_assertion("False.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* Including from file Mdefcode.tmc.11381 */
static void t028(){

pid_t	pid;

 	report_purpose(28);

	report_assertion("Assertion XtAppMainLoop-28.(B)");
	report_assertion("When a widget in the application context specified by");
	report_assertion("app_context has the visible_interest field in its class");
	report_assertion("record set to False a call to void");
	report_assertion("XtAppMainLoop(app_context) shall not dispatch");
	report_assertion("VisibilityUnobscured, VisibilityFullyObscured, or");
	report_assertion("VisbilityPartiallyObscured events to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11381 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
