/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAddConverter()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsRectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#ifndef XavsRChar
#define XavsRChar "Char"
#endif
void XtCVT_Proc(args, num_args, from_val, to_val)
XrmValue* args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
	/*
	** Convert string to character 
	*/
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	avs_set_event(1, avs_get_event(1)+1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
}
void XtCVT_Proc10(args, num_args, from_val, to_val)
XrmValue* args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
	/*
	** Convert string to character 
	*/
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	avs_set_event(2, 1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
}

#define NUMARGS 8
XtConvertArgRec cargs[NUMARGS];
int argdata[NUMARGS] = {
	0,	/*don't care*/
	2002,
	0,	
	4004,
	0,	
	0,	
	0,	
	8008	
};

void xcap(w, size, value)
Widget w;
Cardinal *size;
XrmValue *value;
{
	avs_set_event(2, avs_get_event(2)+1);
	value->addr = (XtPointer)&argdata[7];
	value->size = sizeof(argdata[7]);
}

void init_args(checknum)
int checknum;
{
	cargs[0].address_mode = XtImmediate;
	cargs[0].address_id = (XtPointer)checknum;
	cargs[0].size = sizeof(XtPointer);

/*XtAddress*/
	cargs[1].address_mode = XtAddress;
	cargs[1].address_id = (XtPointer)&argdata[1];
	cargs[1].size = sizeof(XtPointer);

/*XtBaseOffset*/
	cargs[2].address_mode = XtBaseOffset;
	cargs[2].address_id = (XtPointer)XtOffset(Widget, core.screen);
	cargs[2].size = sizeof(Screen*);

/*XtImmediate*/
	cargs[3].address_mode = XtImmediate;
	cargs[3].address_id = (XtPointer)argdata[3];
	cargs[3].size = sizeof(XtPointer);

/*XtResourceString*/
	cargs[4].address_mode = XtImmediate;
	cargs[4].address_id = (XtPointer)argdata[4];
	cargs[4].size = sizeof(XtPointer);

/*XtResourceQuark*/
	cargs[5].address_mode = XtImmediate;
	cargs[5].address_id = (XtPointer)argdata[5];
	cargs[5].size = sizeof(XtPointer);

/*XtWidgetBaseOffset*/
	cargs[6].address_mode = XtWidgetBaseOffset;
	cargs[6].address_id = (XtPointer)XtOffset(Widget, core.self);
	cargs[6].size = sizeof(Widget);

/*XtProcedureArg*/
	cargs[7].address_mode = XtProcedureArg;
	cargs[7].address_id = (XtPointer)xcap;
	cargs[7].size = sizeof(XtPointer);
}

void XtCVT_ProcA(args, num_args, from_val, to_val)
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
int	checknum;

	avs_set_event(1, avs_get_event(1)+1);
	tet_infoline("TEST: Additional arguments passed to converter");
	if (*num_args != NUMARGS) {
		sprintf(ebuf, "ERROR: expected %d arguments, received %d", NUMARGS, *num_args);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}

	checknum = (int)(*(XPointer *)args[0].addr);

	if (checknum == 0) {
		tet_infoline("ERROR: args[0].addr = 0");
		tet_result(TET_FAIL);
		return;
	}
	if (checknum > NUMARGS) {
		sprintf(ebuf, "ERROR: args[0].addr = %d, should be < %d", checknum, NUMARGS);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}
	if (args[checknum].addr == NULL) {
		sprintf(ebuf, "ERROR: args[%d].addr = NULL", checknum);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}

	switch (checknum) {
	case 1:
	case 7:
		if (((int)*(int *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(int *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 2:
		if (((Screen*)*(Screen**)args[checknum].addr) != topLevel->core.screen) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.screen, ((Screen*)*(Screen**)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 3:
		if (((int)*(XPointer *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(XPointer *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 6:
		if (((Widget)*(Widget*)args[checknum].addr) != topLevel->core.self) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.self, ((Widget)*(Widget*)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	default:
		sprintf(ebuf, "ERROR: Unknown argument type %d", checknum);
		tet_infoline(ebuf);
		tet_result(TET_UNRESOLVED);
		return;
	}
	return;
}


#define T_XtAddConverter	1
char    *TestName = "XtAddConverter";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAddConverter-1.(A)");
	report_assertion("A successful call to void XtAddConverter(from_type,");
	report_assertion("to_type, converter, convert_args, num_args) shall register");
	report_assertion("converter as the procedure that will be called by the");
	report_assertion("Intrinsics to convert a resource value from the");
	report_assertion("representation type from_type to the type to_type in all");
	report_assertion("application contexts created by the calling process,");
	report_assertion("including any future application contexts that may be");
	report_assertion("created.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAddConverter(XtRString,
			XavsRChar,
			XtCVT_Proc,
			(XtConvertArgList)NULL,
			(Cardinal)0);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtDirectConvert(XtCVT_Proc,
		(XrmValuePtr) NULL,
		(Cardinal)0,
		&from,
		&to_in_out);
	tet_infoline("TEST: Converted results");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Check procedure XtCVT_Proc was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "XtCVT_Proc invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t002(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
char	thechar;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAddConverter-2.(A)");
	report_assertion("When more than one converter is registered for the same");
	report_assertion("from_type and to_type by multiple calls to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) the most recently registered converter shall");
	report_assertion("override the previous ones.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAddConverter(XtRString,
			XavsRChar,
			XtCVT_Proc,
			(XtConvertArgList)NULL,
			(Cardinal)0);
	tet_infoline("TEST: Register XtCVT_Proc10 for same conversion");
	XtAddConverter(XtRString,
			XavsRChar,
			XtCVT_Proc10,
			(XtConvertArgList)NULL,
			(Cardinal)0);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &thechar;
	to_in_out.size = sizeof(char);
	XtConvertAndStore(topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out);
	tet_infoline("TEST: Converted results");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Check procedure XtCVT_Proc was not invoked");
	status = avs_get_event(1);
	check_dec(0, status, "XtCVT_Proc invocations count");
	tet_infoline("TEST: Check procedure XtCVT_Proc10 not invoked");
	status = avs_get_event(2);
	check_dec(1, status, "XtCVT_Proc10 invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t003(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
char	thechar;
char *thestring = "Hello";
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAddConverter-3.(A)");
	report_assertion("On a call to void XtAddConverter(from_type, to_type,");
	report_assertion("converter, convert_args, num_args) the converter procedure");
	report_assertion("shall be registered such that the results of a previous");
	report_assertion("conversion will be reused for subsequent resource requests");
	report_assertion("with the same source value and conversion arguments.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAddConverter(XtRString,
			XavsRChar,
			XtCVT_Proc,
			(XtConvertArgList)NULL,
			(Cardinal)0);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	from.addr = thestring;
	from.size = sizeof(String);
	to_in_out.addr = &thechar;
	to_in_out.size = sizeof(char);
	XtConvertAndStore(topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out);
	tet_infoline("TEST: Reinvoke resource converter with same arguments");
	from.addr = thestring;
	from.size = sizeof(String);
	to_in_out.addr = &thechar;
	to_in_out.size = sizeof(char);
	XtConvertAndStore(topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out);
	tet_infoline("TEST: Converted results");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Convertor was invoked just once");
	status = avs_get_event(1);
	check_dec(1, status, "XtCVT_Proc invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t004(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAddConverter-4.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtAddress it shall be called by the Intrinsics with the data");
	report_assertion("pointed to by the address_id field passed as a conversion");
	report_assertion("argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(1);
	XtAddConverter(XtRString,
		XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t005(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAddConverter-5.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtBaseOffset it shall be called by the Intrinsics with the");
	report_assertion("data at an offset of address_id from the base of the widget,");
	report_assertion("in whose context the converter is invoked, passed as a");
	report_assertion("conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(2);
	XtAddConverter(XtRString,
		XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t006(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAddConverter-6.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtImmediate it shall be called by the Intrinsics with the");
	report_assertion("data in the address_id field passed as a conversion");
	report_assertion("argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(3);
	XtAddConverter(XtRString,
		XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

/* Including from file Mdefcode.tmc.12303 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAddConverter-7.(B)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtResourceString it shall be called by the Intrinsics with");
	report_assertion("the value of the resource for the widget that is named by");
	report_assertion("the address_id passed as a conversion argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.12303 */

/* Including from file Mdefcode.tmc.12303 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtAddConverter-8.(B)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtResourceQuark it shall be called by the Intrinsics with");
	report_assertion("the offset of the resource from the base of the widget, in");
	report_assertion("whose context the converter is invoked, for the resource");
	report_assertion("string specified by the quark value in the address_id field");
	report_assertion("passed as a conversion argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.12303 */

static void t009(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
Widget test_widget;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtAddConverter-9.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtWidgetBaseOffset it shall be called by the Intrinsics with");
	report_assertion("the data at an offset of address_id in the closest windowed");
	report_assertion("ancestor of the widget in whose context the converter is");
	report_assertion("called, when the widget is not of a subclass of Core, passed");
	report_assertion("as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
        tet_infoline("PREP: Create AVS RectObj widget");
        test_widget = XtVaCreateManagedWidget("avsro", avsrectObjClass, topLevel, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(6);
	XtAddConverter(XtRString,
		XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtConvertAndStore(
		test_widget,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

static void t010(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtAddConverter-10.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAddConverter(from_type, to_type, converter, convert_args,");
	report_assertion("num_args) with the address_mode member of an XtConvertArgRec");
	report_assertion("structure in the list pointed to by convert_args set to");
	report_assertion("XtProcedureArg it shall be called by the Intrinsics with the");
	report_assertion("value returned by the function pointed to by the address_id");
	report_assertion("field passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadconvtr1", "XtAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	init_args(7);
	XtAddConverter(XtRString,
		XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocations count");
	tet_infoline("TEST: function was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "function invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12303 */
/* End of included file Mdefcode.tmc.12303 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
