#ifndef __NVC0_QUERY_HW_SM_H__
#define __NVC0_QUERY_HW_SM_H__

#include "nvc0_query_hw.h"

struct nvc0_hw_sm_query {
   struct nvc0_hw_query base;
   uint8_t ctr[8];
};

static inline struct nvc0_hw_sm_query *
nvc0_hw_sm_query(struct nvc0_hw_query *hq)
{
   return (struct nvc0_hw_sm_query *)hq;
}

/*
 * Performance counter queries:
 */
#define NVC0_HW_SM_QUERY(i)    (PIPE_QUERY_DRIVER_SPECIFIC + (i))
#define NVC0_HW_SM_QUERY_LAST   NVC0_HW_SM_QUERY(NVC0_HW_SM_QUERY_COUNT - 1)
enum nvc0_hw_sm_queries
{
   NVC0_HW_SM_QUERY_ACTIVE_CYCLES = 0,
   NVC0_HW_SM_QUERY_ACTIVE_WARPS,
   NVC0_HW_SM_QUERY_ATOM_CAS_COUNT,
   NVC0_HW_SM_QUERY_ATOM_COUNT,
   NVC0_HW_SM_QUERY_BRANCH,
   NVC0_HW_SM_QUERY_DIVERGENT_BRANCH,
   NVC0_HW_SM_QUERY_GLD_REQUEST,
   NVC0_HW_SM_QUERY_GLD_MEM_DIV_REPLAY,
   NVC0_HW_SM_QUERY_GST_TRANSACTIONS,
   NVC0_HW_SM_QUERY_GST_MEM_DIV_REPLAY,
   NVC0_HW_SM_QUERY_GRED_COUNT,
   NVC0_HW_SM_QUERY_GST_REQUEST,
   NVC0_HW_SM_QUERY_INST_EXECUTED,
   NVC0_HW_SM_QUERY_INST_ISSUED,
   NVC0_HW_SM_QUERY_INST_ISSUED1,
   NVC0_HW_SM_QUERY_INST_ISSUED2,
   NVC0_HW_SM_QUERY_INST_ISSUED1_0,
   NVC0_HW_SM_QUERY_INST_ISSUED1_1,
   NVC0_HW_SM_QUERY_INST_ISSUED2_0,
   NVC0_HW_SM_QUERY_INST_ISSUED2_1,
   NVC0_HW_SM_QUERY_L1_GLD_HIT,
   NVC0_HW_SM_QUERY_L1_GLD_MISS,
   NVC0_HW_SM_QUERY_L1_GLD_TRANSACTIONS,
   NVC0_HW_SM_QUERY_L1_GST_TRANSACTIONS,
   NVC0_HW_SM_QUERY_L1_LOCAL_LD_HIT,
   NVC0_HW_SM_QUERY_L1_LOCAL_LD_MISS,
   NVC0_HW_SM_QUERY_L1_LOCAL_ST_HIT,
   NVC0_HW_SM_QUERY_L1_LOCAL_ST_MISS,
   NVC0_HW_SM_QUERY_L1_SHARED_LD_TRANSACTIONS,
   NVC0_HW_SM_QUERY_L1_SHARED_ST_TRANSACTIONS,
   NVC0_HW_SM_QUERY_LOCAL_LD,
   NVC0_HW_SM_QUERY_LOCAL_LD_TRANSACTIONS,
   NVC0_HW_SM_QUERY_LOCAL_ST,
   NVC0_HW_SM_QUERY_LOCAL_ST_TRANSACTIONS,
   NVC0_HW_SM_QUERY_NOT_PRED_OFF_INST_EXECUTED,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_0,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_1,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_2,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_3,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_4,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_5,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_6,
   NVC0_HW_SM_QUERY_PROF_TRIGGER_7,
   NVC0_HW_SM_QUERY_SHARED_LD,
   NVC0_HW_SM_QUERY_SHARED_LD_REPLAY,
   NVC0_HW_SM_QUERY_SHARED_ST,
   NVC0_HW_SM_QUERY_SHARED_ST_REPLAY,
   NVC0_HW_SM_QUERY_SM_CTA_LAUNCHED,
   NVC0_HW_SM_QUERY_THREADS_LAUNCHED,
   NVC0_HW_SM_QUERY_TH_INST_EXECUTED,
   NVC0_HW_SM_QUERY_TH_INST_EXECUTED_0,
   NVC0_HW_SM_QUERY_TH_INST_EXECUTED_1,
   NVC0_HW_SM_QUERY_TH_INST_EXECUTED_2,
   NVC0_HW_SM_QUERY_TH_INST_EXECUTED_3,
   NVC0_HW_SM_QUERY_UNCACHED_GLD_TRANSACTIONS,
   NVC0_HW_SM_QUERY_WARPS_LAUNCHED,
   NVC0_HW_SM_QUERY_COUNT
};

struct nvc0_hw_query *
nvc0_hw_sm_create_query(struct nvc0_context *, unsigned);
int
nvc0_hw_sm_get_driver_query_info(struct nvc0_screen *, unsigned,
                                 struct pipe_driver_query_info *);
unsigned
nvc0_hw_sm_get_num_queries(struct nvc0_screen *);

#endif
